/**
 * Device Details Types
 */

export interface DeviceDetails {
  id: string;
  name: string;
  type: string;
  status?: 'online' | 'offline' | 'unknown';
  ipAddress?: string;
  macAddress?: string;
  lastSeen?: Date;
  metadata?: Record<string, unknown>;
}

export interface DeviceDetailsGenerator {
  (type: string): Promise<DeviceDetails>;
}
