/**
 * Drag and Drop Types
 */

import type { AccessPointMarkerPoint } from '@/app/types/AccessPointMarker';

export interface NewDragItem {
  type: string;
  isNew: true;
}

export interface ExistingDragItem extends AccessPointMarkerPoint {
  isNew: false;
}

export type DragItem = NewDragItem | ExistingDragItem;

export interface TouchDragPreview {
  x: number;
  y: number;
  visible: boolean;
}

export interface DragPosition {
  x: number;
  y: number;
}
