/**
 * PDF and File Types
 */

export interface PDFFileBase {
  name: string;
  size: number;
  originalName: string;
  uploadedPath: string | null;
}

export interface PDFFileWithFile extends PDFFileBase {
  file: File;
}

export type PDFFile = PDFFileBase | PDFFileWithFile;

export interface PDFProcessingOptions {
  scale?: number;
  quality?: number;
  maxSize?: number;
}
