/**
 * Viewport State Types
 * Types for viewport transformations (zoom, pan, rotation)
 */

export interface ViewportState {
  zoomLevel: number;
  panOffset: { x: number; y: number };
  rotation: number;
  isPanning: boolean;
  lastPanPosition: { x: number; y: number };
}

export type ViewportAction =
  | { type: 'SET_ZOOM'; payload: number }
  | { type: 'ZOOM_IN' }
  | { type: 'ZOOM_OUT' }
  | { type: 'SET_PAN'; payload: { x: number; y: number } }
  | { type: 'START_PAN'; payload: { x: number; y: number } }
  | { type: 'UPDATE_PAN'; payload: { x: number; y: number } }
  | { type: 'END_PAN' }
  | { type: 'SET_ROTATION'; payload: number }
  | { type: 'ROTATE_LEFT' }
  | { type: 'ROTATE_RIGHT' }
  | { type: 'RESET_VIEW' };

export interface ImageDimensions {
  width: number;
  height: number;
}

export interface PageViewportState {
  zoomLevel: number;
  panOffset: { x: number; y: number };
  rotation?: number;
}
