export const formatDateTime = (dateString: string | null | undefined): string  =>{
  // if empty
  if (!dateString) {

    return '-';
  }

  const date = new Date(dateString);

  if (isNaN(date.getTime())) {
    return 'invalid date input';
  }

  const formattedDate = date.toLocaleDateString(undefined, {
    year: 'numeric',
    month: 'long',
    day: 'numeric',
  });

  const formattedTime = date.toLocaleTimeString(undefined, {
    hour: 'numeric',
    minute: 'numeric',
    second: 'numeric',
  });

  return `${formattedDate} ${formattedTime}`;
}
