import Device from "@/app/types/Device";

/**
 * Return the number of online users and their total number
 * @param items: List of devices
 * @returns { onlineCount: number, totalCount: number }
 */
export const getUserStats = (items: Device[]) : { onlineCount: number; totalCount: number } => {
  const onlineCount = items.reduce((acc: number, device: Device) => (device.online ? acc + 1 : acc), 0);
  const totalCount = items.length;

  return { onlineCount, totalCount };
}

/**
 * Return the signal of online users and their total number
 * @param siganl{number}: Device's signal
 * @returns string: Status
 */
export const CheckSignal = (value: number) => {
  if (value <= -80) return 'bad';
  if (value <= -70) return 'moderate';
  if (value <= -60) return 'moderate';
  if (value <= -30) return 'good';
  return 'bad';
}

export const bytesToMB = (bytes: number) => {
  const numBytes = Number(bytes);
  return Math.floor(numBytes / (1000 * 1000));
}
