#!/bin/bash

set -x

ACTION="$1"
CACHE_ARCHIVE="build-meta/cache/cache.tar.gz"

if [ "$ACTION" == "restore" ]; then
	# Check if file exists
	if [ -f "$CACHE_ARCHIVE" ]; then
		# Extract cache
		tar xf $CACHE_ARCHIVE -C $CI_OPENWRT_BUILD_DIR
		echo "Cache restored"
	else
		echo "Cache archive not found"
	fi
	exit 0
elif [ "$ACTION" == "save" ]; then
	if [ -f "$CACHE_ARCHIVE" ]; then
		echo "Cache archive already exists"
		exit 0
	fi
	# Create cache directory
	mkdir -p $(dirname $CACHE_ARCHIVE)
	# Create cache archive
	tar czf $CACHE_ARCHIVE -C $CI_OPENWRT_BUILD_DIR --posix build_dir staging_dir
	echo "Cache saved"
	exit 0
else
	echo "Invalid action"
	exit 1
fi

exit 0