#!/bin/bash

EXTRA_PKGS="\
	batctl-full \
	curl \
	iftop \
	ip-full \
	iperf3 \
	kmod-batman-adv \
	kmod-wireguard \
	prometheus-node-exporter-lua \
	prometheus-node-exporter-lua-nat_traffic \
	prometheus-node-exporter-lua-netstat \
	prometheus-node-exporter-lua-openwrt \
	prometheus-node-exporter-lua-wifi \
	prometheus-node-exporter-lua-wifi_stations \
	rsync \
	ss \
	tc tc-full \
	tcpdump \
	tmux \
	uconfig \
	uniberg-auther \
	uniberg-statsd \
	uniberg-uconfigd \
	uniberg-wifi-mesh-qos \
	wireguard-tools \
	wpad-mbedtls \
	jq \
"

EXTRA_PKGS_CONTROLLER="\
	sqlite3-cli \
	mtr-json \
	htop \
	iptables \
	kmod-nft-compat \
	kmod-ipt-core \
	nginx-full \
	uniberg-frontend \
	uniberg-uconfigd-role-controller \
	uniberg-uconfigd-controller \
	uniberg-ub-edge-api \
	picocom \

"

DEFCONFIG_PATH="$1"
ROLE="$2"

CONFIG="$(cat $DEFCONFIG_PATH)"

PACKAGE_SET=""

if [ "$ROLE" = "controller" ]; then
	PACKAGE_SET="$EXTRA_PKGS $EXTRA_PKGS_CONTROLLER"
elif [ "$ROLE" = "ap" ]; then
	PACKAGE_SET="$EXTRA_PKGS uniberg-uconfigd-role-ap"
fi

for package in $PACKAGE_SET; do
	if ! echo "$CONFIG" | grep -q "^CONFIG_PACKAGE_$package=y"; then
		CONFIG="$CONFIG\nCONFIG_PACKAGE_$package=y"
	fi
done

# Remove wpad-basic
CONFIG="$CONFIG\n# CONFIG_PACKAGE_wpad-basic-mbedtls is not set"

echo -e "$CONFIG"
