# keyserver, wireguard, ssh remotecontrol, initial wg keys deployment

## working principle
out of the box, the controller image trusts aws (via ssh public key)

initial key deployment via ssh: controller fetches unique private IP, new private/public keypair for wireguard (wg) and access to aws private IP in same subnet via the wg tunnel.

no ssh should be necessary any more, proper IP networking is more versatile.

as a backup, we keep the ssh connection workable, in case something goes wrong with wg (it involves a few more layers, vs. ssh needing just ip/tcp/application layer).

## keyserver
2024-02-11
This directory originally was the source of aws/wireguard config. Now it has a mostly documenting and historical role. in case we ever replace the aws instance we need to recreate the steps here.
The are scripts used to create keys, configuration, the resulting public keys, the resulting inventory are pushed to git here.
For security i'm trying to avoid putting private keys on git, so they are found on aws and also right now backed up locally (Jannis). 

Individual keys are to be given to 1) aws 2) multiple possible admins 3) each teltonika ub-edge controllers.
theoretically the architecture does allow that admins do not get to see private keys without going a certain extra step for circumvention.
if we ever do truly multi-site multi-corporation stuff though, it is possible to create multiple silos to contain the possible circumvention per site.
also, with strongly enforced trust-on-first-use (tofu) we should have none of these problems, but a superadmin is needed to reset an already trusted key relation.

## deployment on aws, image

0)
put into teltonika root image (done done: already has been put into uconfigd git master, we can probably delete the files here to avoid duplicates)
    cd ~/src/keyserver
    # rsync is dry-run, remove -n after checking
    rsync -nhPvirpt wrt-dot-ssh/ root@192.168.133.1:.ssh/

0b)
# in keyserver repo
    cp clientscript[0-9]*.sh clientwgcfg[0-9]* cfg/

1) 
on aws as root (done)
ssh root@aws
    systemctl mask user@.service #prevent systemd from spamming useless user services
	chmod 750 /home/* 
	useradd deploy
	mkdir /home/deploy
	chown -R deploy /home/deploy

2)
copy these to aws (done)
    cd ~/src/keyserver
    # rsync is dry-run, remove -n after checking
    rsync -nhPvirpt serverscript.sh admin@aws: 
    rsync -nhPvirpt forced-command.sh client.sh admin.sh cfg deploy-dot-ssh deploy@aws:/home/deploy/
    #rsync -nhPvirpt inventory forced-command.sh client.sh admin.sh cfg deploy-dot-ssh deploy@aws:/home/deploy/    #removed inventory as single point of truth for that is on aws

3)
run on aws:
    ssh deploy@aws
    rmdir .ssh
    mv deploy-dot-ssh/ .ssh
    mkdir incoming
    ./admin.sh #best to do in tmux so we can watch the log

4) turn on a controller reset to a fresh image with uconfigd
