#!/bin/bash
db=/home/deploy
in=$db/incoming
mkdir $in 2>/dev/null
mkfifo $in/event.fifo 2>/dev/null
cd $db
error(){
	echo
	echo error: $* 1>&2
}
panic(){
	echo
	echo panic: $*
	echo exiting.
	exit
}
unlock(){
	echo
	echo graceful cleanup
	rmdir one.lock
	exit
}
init(){
	[ -d $net ] || echo $net doesnt exist.
	echo `date +%s` $mac init $net >> init.log
}
mustbealphanum(){
	echo "$1" | sed 's/[^:0-9a-zA-Z]//g'
}
mustbemac(){
	echo "$1" | sed 's/[^:0-9a-fA-F]//g'
}
mkdir one.lock || panic cant run twice
trap unlock HUP INT QUIT TERM

exec {up}<> $in/event.fifo
#exec {down}<> down.fifo
#echo "macasdf8112481" >&$up #test input &
while read mac <&$up
do
	echo -n "."
	cat >> $in/$mac/down.fifo <<EOF
. /usr/bin/uniberg-features.sh
live ssh 1
EOF
	last=$(tail -n1 $db/inventory |awk '{print $1}') 
	n=$((last+1))
	if [ "$n" -gt 21 ] && [ "$n" -lt 91 ]
	then
		macinv=''
		macinv=$(awk '/ '$mac'/{print $2}' inventory)
		if grep "^$n[^0-9]" inventory || [ -n "$macinv" ]
		then
			error duplicate $n $mac 
			echo echo cannot add $mac to inventory. >> $in/$mac/down.fifo
		else
			echo
			echo writing $n $mac into inventory
			echo $n $mac >> $db/inventory
			cat $db/cfg/clientscript$n.sh $db/cfg/clientwgcfg$n >> $in/$mac/down.fifo
			echo echo wg0 config saved to flash >> $in/$mac/down.fifo
		fi
	else
		error $n for $mac not in range.
		echo echo cannot add $mac to inventory. >> $in/$mac/down.fifo
	fi
	echo 'echo exiting.; exit' >> $in/$mac/down.fifo

	sleep 0.1
	echo >> $in/$mac/down.fifo # s33cr337 hack to close pipe :P
	sleep 0.1
	echo >> $in/$mac/down.fifo

	sleep 1 #rate-limit
done
unlock
exit

