#!/bin/sh
error(){
	echo "$@"
	echo exiting.
	exit 1
}
keys(){
	umask 077
	for bla in `seq 1 99`; do 
		wg genkey > privatekey.$bla; 
		wg pubkey < privatekey.$bla > publickey.$bla
	done
}

cfgwrt(){
VPN_IF=wg0
cat <<EOF
config interface '${VPN_IF}'
	option proto 'wireguard'
	option private_key '$(cat privatekey.$n)'
	list addresses '${prefix}.$n/24'

config wireguard_${VPN_IF} 'wgserver'
	option public_key '$(cat publickey.$serverid)'
	option endpoint_host '${VPN_SERV}'
	option endpoint_port '${VPN_PORT}'
	option persistent_keepalive '25'
	list allowed_ips '0.0.0.0/0'
	list allowed_ips '::/0'
EOF
}
cfguci(){
VPN_IF=wg0
cat <<EOF
uci -q delete network.wgserver
uci -q delete network.${VPN_IF}
uci set network.${VPN_IF}="interface"
uci set network.${VPN_IF}.proto="wireguard"
uci set network.${VPN_IF}.private_key="$(cat privatekey.$n)"
uci add_list network.${VPN_IF}.addresses="${prefix}.$n/24"
uci set network.wgserver="wireguard_${VPN_IF}"
uci set network.wgserver.public_key="$(cat publickey.$serverid)"
uci set network.wgserver.endpoint_host="${VPN_SERV}"
uci set network.wgserver.endpoint_port="${VPN_PORT}"
uci set network.wgserver.persistent_keepalive="25"
uci add_list network.wgserver.allowed_ips="0.0.0.0/0"
uci add_list network.wgserver.allowed_ips="::/0"
EOF
#uci set network.wgserver.route_allowed_ips="1"
#uci add_list network.${VPN_IF}.addresses="${VPN_ADDR6}"
#uci set network.wgserver.preshared_key="${VPN_PSK}"
}

configureclient(){
echo "# client$n: $1
[Interface]
PrivateKey = `cat privatekey.$n`
# client$n.
[Peer]
PublicKey = `cat publickey.$serverid`
Endpoint = $VPN_SERV:$VPN_PORT
AllowedIPs = 0.0.0.0/0
PersistentKeepalive = 25
" 
}

clientscript(){
echo "
cat > /etc/uniberg/configd-controller/data/wg0.sh <<EOF
ip link add dev wg0 type wireguard 2>/dev/null || true
ip address add dev wg0 $prefix.$n/24 2>&1 | grep -v 'File exists'
wg setconf wg0 /etc/uniberg/configd-controller/data/wg0.conf
ip link set up dev wg0
wg show wg0 latest-handshakes|grep LesxdDtxLN5PHyDfIn3e6nbNANz+RvsykYXzz5lyfxM= >/dev/null 2>/dev/null ||
        echo wg0: no handshake.
EOF
" 
}

clientspublic(){
echo "# peer${n}: $1
[Peer]
PublicKey = `cat publickey.${n}`
AllowedIPs = $prefix.${n}/32
# peer${n}.
" 
}

server(){
	#usage: server "setup name"
	echo "# $1 serverid=$serverid
[Interface]
ListenPort = $VPN_PORT
PrivateKey = `cat privatekey.$serverid`

" > serverconfig


echo "
ip link del wg0 || true
ip link add dev wg0 type wireguard
ip address add dev wg0 $prefix.$serverid/24
wg setconf wg0 serverconfig
ip link set up dev wg0
" > serverscript.sh
chmod +x serverscript.sh
}

clients(){
for n in `seq $start $end` `seq $startadmin $endadmin`
do
	clientspublic "ub-edge lite client" >> serverconfig
	configureclient "ub-edge lite client" > clientconfig$n
	( echo 'cat > /etc/uniberg/configd-controller/data/wg0.conf <<EOF'
	  configureclient "ub-edge lite client" 
	  echo 'EOF'
	) > clientwgcfg$n
	cfguci "ub-edge lite client" > wrt$n
	cfgwrt "ub-edge lite client" > wrtcfg$n
	clientscript > clientscript$n.sh
done
}

ctr(){
n=$2
name=$1
[ -z "$name" ] &&
	error admin name is empty 
[ $# -eq 2 ] && [ $n -le $end ] && [ $start -le $n ] ||
	error ctrlr id for $name not in range $start:$end
sed "s/client$n/client$n: controller $name/" clientconfig$n > tmp$n &&
	mv tmp$n clientconfig$n
}
admin(){
n=$2
name=$1
[ -z "$name" ] &&
	error admin name is empty 
[ $# -eq 2 ] && [ $n -le $endadmin ] && [ $startadmin -le $n ] ||
	error admin id for $name not in range $startadmin:$endadmin
sed "s/client$n/client$n: admin $name/" clientconfig$n > tmp$n &&
	mv tmp$n clientconfig$n
}

# #####################   M A I N  #############

#keys #dont rerun, lest we lose the keys

#serverside
prefix=192.168.201 serverid=1 start=21 end=90 VPN_SERV=35.157.207.77 VPN_PORT=51820
startadmin=91 endadmin=99
server "ub-edge lite setup" 
clients
ctr teltonika1 21
ctr teltonika2 22
admin arthur 91
admin jannis 92
admin david 93
