#!/usr/bin/env python3
import os
import sys
import time

from labgrid.environment import Environment
from labgrid.consoleloggingreporter import ConsoleLoggingReporter

def get_script_path():
	return os.path.dirname(os.path.realpath(sys.argv[0]))

def get_firmware_download_url(target_ip, device_if, filename):
	return f"http://[{target_ip}%{device_if}]/tftp/{filename}"

def install(target, upgrade_filename):
	s = target.get_driver('UBootStrategy')
	s.transition('uboot')
	print("Booted into U-Boot")

	uboot = target.get_driver("UBootDriver")
	# ToDo: Might want to consider putting this into some kind of expect upon linkup ( Check host up?)
	# Takes absurdly long because PoE injector has to wait for downshift to 100 Mbit
	time.sleep(10)
	print('Invoke Netboot')
	uboot.boot('net')
	uboot.await_boot()
	print("Booting into Linux")

	# Workaround: Login settle time does not honor in case we have no password upon login!
	# This currently fails as interrupting the boot process fucks up the liveness detection.
	# Remove once upstream merged .... and we updated accordingly
	time.sleep(60)

	shell = target.get_driver("ShellDriver")
	target.activate(shell)
	print('Booted into Linux')

	first_try = time.time()
	while first_try + 60 > time.time():
		data, _, rc = shell.run(f"wget -O /tmp/fw.bin {get_firmware_download_url('fe80::227b:d2ff:fe22:7e27', 'br-lan', upgrade_filename)}")
		print("data=%s, rc=%s" % (data, rc))
		time.sleep(3)
		if rc == 0:
			break
	
	data, _, rc = shell.run("sysupgrade -T /tmp/fw.bin")
	if rc != 0:
		print("Sysupgrade not valid")
		sys.exit(1)
	
	print("Starting Sysupgrade")
	shell.console.sendline("sysupgrade -n /tmp/fw.bin")
	print("Waiting for Reboot")
	time.sleep(10)
	shell.console.expect("sysupgrade successful", timeout=float(60))
	print("Done")

if __name__ == '__main__':
	target = None
	action = "toggle"
	if len(sys.argv) < 3:
		print("Usage: %s <target_name> <firmware-file>" % sys.argv[0])
		sys.exit(1)
	
	# Write to /tmp/labrid-logs/
	ConsoleLoggingReporter.start("/tmp/labgrid-logs/")

	target_name = sys.argv[1]
	upgrade_filename = sys.argv[2]
	if target_name not in ['teltonika', 'ap1', 'ap2']:
		print("Invalid target %s" % target)
		sys.exit(1)
	
	env = Environment(f"{get_script_path()}/targets.yaml")
	target = env.get_target(target_name)

	install(target, upgrade_filename)
