#!/bin/bash

error(){
	echo error: install-firmware.sh: "$@" >&2
}

export LG_CROSSBAR="ws://10.42.3.39:20408/ws"
source "/tmp/labgrid-venv/bin/activate"

# Release place

for dev in $@
do
	echo releasing device $dev
	labgrid-client -p $dev release &
done

wait


for dev in $@
do
	[ -e /tmp/$dev.err ] && error previous "$dev" install: "$(cat /tmp/$dev.err)"
done

for dev in $@
do
	[ -e /tmp/$dev.err ] && exit 1
done
