#!/bin/bash

error(){
	echo error: install-firmware.sh: "$@" >&2
	echo error: install-firmware.sh: "$@" >>/tmp/$1.err
	exit 1
}

[ -e /tmp/$1.err ] && rm /tmp/$1.err 
[ -n "$1" ] && [ -n "$2" ] || error arguments missing

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"
TARGET_DEVICE="$1"
FIRMWARE_IMAGE_PATH="$2"

[ -e "$FIRMWARE_IMAGE_PATH" ] || error fw img path not found

export LG_CROSSBAR="ws://10.42.3.39:20408/ws"

# Setup Labgrid environment
source "/tmp/labgrid-venv/bin/activate"

LABBOOK_FW_NAME="$(md5sum "$FIRMWARE_IMAGE_PATH" | cut -d ' ' -f 1)"

# Copy firmware image to Labbook
scp -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -i "$HOME/.ssh/id_ci-firmware-install" "$FIRMWARE_IMAGE_PATH" "uniberg@10.42.3.39:/srv/tftp/$LABBOOK_FW_NAME" || 
	error "$1" scp failed

# Install firmware
python3 $SCRIPT_DIR/install-firmware.py $TARGET_DEVICE $LABBOOK_FW_NAME ||
	error "$1" install-firmware.py failed
