#!/bin/bash

set -xe

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Setup Labgrid environment
python3 -m venv "/tmp/labgrid-venv"
source "/tmp/labgrid-venv/bin/activate"
python3 -m pip install --upgrade pip
python3 -m pip install labgrid==v24.0.2
python3 -m pip install "labgrid[snmp]==v24.0.2"

# Move SSH key to correct location
mkdir -p "$HOME/.ssh"
cp $SCRIPT_DIR/contrib/id_ci-firmware-install* "$HOME/.ssh/"
chmod 0600 "$HOME/.ssh/id_ci-firmware-install"

# Add labbook to hosts
echo "10.42.3.39      labbook" | tee -a /etc/hosts
cat /etc/hosts
