import attr

from labgrid.driver import SmallUBootDriver
from labgrid.factory import target_factory
from labgrid.step import step
from labgrid.driver import Driver


@target_factory.reg_driver
@attr.s(eq=False)
class ZyxelUbootDriver(SmallUBootDriver):
	@Driver.check_active
	@step(args=['name'], result=True)
	def boot(self, name):
		# Name if only for compatibility reasons.
		cmds = [
			"atna 192.168.133.90",
			"atnf recovery-nwa50ax.bin",
			"atns \"192.168.133.39; tftpboot; bootm\""
		]
		for cmd in cmds:
			self.console.sendline(cmd)
			self.console.expect(self.prompt)
