#!/bin/sh

set -xe

JWT_SECRET_FILE="/lib/uniberg/edge-api/data/jwt_secret"
ADMIN_PASS_FILE="/lib/uniberg/edge-api/data/admin_pass"
EDGE_CONTROLLER_API_FILE="/lib/uniberg/edge-api/data/edge_controller_api"

function generate_secret() {
	head -c 32 /dev/urandom | md5sum | cut -d ' ' -f 1
}

# Generate JWT secret
if [ ! -f "$JWT_SECRET_FILE" ]; then
	mkdir -p "$(dirname "$JWT_SECRET_FILE")"
	echo -n "$(generate_secret)" > "$JWT_SECRET_FILE"
fi

# Generate admin password
if [ ! -f "$ADMIN_PASS_FILE" ]; then
	mkdir -p "$(dirname "$ADMIN_PASS_FILE")"
	echo -n "Uniberg123!" > "$ADMIN_PASS_FILE"
fi

# Configure Edge Endpoint
if [ ! -f "$EDGE_CONTROLLER_API_FILE" ]; then
	mkdir -p "$(dirname "$EDGE_CONTROLLER_API_FILE")"
	echo -n "http://localhost:8844" > "$EDGE_CONTROLLER_API_FILE"
fi
