#!/bin/sh

. /lib/functions.sh

function get_ipv6_from_mac() {
	MAC="$(echo $1 | sed 's/://g')"

	# MAC to lower case
	MAC="$(echo $MAC | tr '[:upper:]' '[:lower:]')"

	# Insert : after every 4 characters
	IPv6="$(echo $MAC | sed 's/.\{4\}/&:/g')"

	ADDR="fd42:dead:c0de:1337::$IPv6"

	echo "$(echo "$ADDR" | sed 's/.$//')"
}

# Generate MOTD
MOTD_CONTENT="$(cat /lib/uniberg/motd.txt)"

BUILD_COMMIT=$(cat /lib/uniberg/build/commit)
BUILD_DATE=$(cat /lib/uniberg/build/date)

# Replace variables
MOTD_CONTENT=$(echo "$MOTD_CONTENT" | sed "s/%BUILD_COMMIT%/${BUILD_COMMIT}/g")
MOTD_CONTENT=$(echo "$MOTD_CONTENT" | sed "s/%BUILD_DATE%/${BUILD_DATE}/g")

echo "$MOTD_CONTENT" > /etc/banner

# Create directories
mkdir -p /etc/uconfig/uniberg/config
mkdir -p /lib/uniberg/uconfig/system
mkdir -p /lib/uniberg/uconfig/system/hardware

# Get label-mac
/lib/uniberg/uconfigd/scripts/get-label-mac.sh > /lib/uniberg/uconfig/system/label_mac

# Get Setup-WiFi SSID. Last 4 characters of MAC withouth ":".
SSID_SUFFIX="$(cat /lib/uniberg/uconfig/system/label_mac | sed 's/://g' | cut -c 9-13)"
echo "UB-EDGE-$SSID_SUFFIX" > /lib/uniberg/uconfig/system/hardware/wifi_ssid

# Get default WiFi password
case "$(board_name)" in
	"teltonika,rutx50")
		dd if="$(find_mtd_part "0:CONFIG")" of=/lib/uniberg/uconfig/system/hardware/wifi_password bs=1 skip=144 count=8
		;;
esac

# If no default WiFi password is found, generate one
# Default is first 8 characters of mac-address hash
if [ ! -s /lib/uniberg/uconfig/system/hardware/wifi_password ]; then
	cat /lib/uniberg/uconfig/system/label_mac | sha256sum | cut -c1-8 > /lib/uniberg/uconfig/system/hardware/wifi_password
fi

# Get hostname
echo "ap-$(cat /lib/uniberg/uconfig/system/label_mac)" > /lib/uniberg/uconfig/system/hostname


# Get IPv6 from MAC
echo "$(get_ipv6_from_mac $(cat /lib/uniberg/uconfig/system/label_mac))" > /lib/uniberg/uconfig/system/ipv6
