#!/usr/bin/ucode

'use strict';

import * as fs from 'fs';

function get_wifi_generation(band, radio_capa) {
	if (radio_capa.he) {
		return 6;
	}
	if (radio_capa.vht && band != '2G') {
		return 5;
	}
	if (radio_capa.ht) {
		return 4;
	}

	return 0;
}

function get_wifi_bandwidth(band, radio_capa) {
	if (band == '2G') {
		return 20;
	}

	return radio_capa.max_width;
}

function get_radio(radio) {
	for (let k, v in radio.info.bands) {
		let radio_data = {};
		if (k == '2G') {
			radio_data.band = 2;
		} else {
			radio_data.band = 5;
		}

		radio_data.generation = get_wifi_generation(k, v);
		radio_data.bandwidth = get_wifi_bandwidth(k, v);

		return radio_data;
	}
}

function readfile_strip_newline(file_path) {
	return replace(fs.readfile(file_path), '\n', '');
}

let capa = {
	device: {}
};

let ap_hostname = readfile_strip_newline('/lib/uniberg/uconfig/system/hostname');
let ap_mac = readfile_strip_newline('/lib/uniberg/uconfig/system/label_mac');
let ap_serial = ap_mac;
let ap_ip = readfile_strip_newline('/lib/uniberg/uconfig/system/ipv6');
let ap_role = readfile_strip_newline('/lib/uniberg/role');

let ap_wifi_ssid = readfile_strip_newline('/lib/uniberg/uconfig/system/hardware/wifi_ssid');
let ap_wifi_key = readfile_strip_newline('/lib/uniberg/uconfig/system/hardware/wifi_password');


capa.name = ap_hostname;
capa.mac = ap_mac;
capa.serial = ap_serial;
capa.ip_address = ap_ip;


let board = fs.readfile('/etc/board.json');
board = json(board);

capa.device.compatible = board.model.id;
capa.device.model = board.model.name;
capa.device.role = ap_role;

capa.setup = {};
capa.setup.ssid = ap_wifi_ssid;
capa.setup.key = ap_wifi_key;

if (length(board.wlan)) {
	capa.radios = [ ];
	for (let k, v in board.wlan) {
		push(capa.radios, get_radio(v));
	}
}

fs.writefile('/lib/uniberg/uconfig/system/subscription_object.json', capa);
