#!/bin/sh

if [ -f /etc/uconfig/uniberg/factory.json ]; then
	exit 0
fi

IP6_ADDR="$(cat /lib/uniberg/uconfig/system/ipv6)"
MACADDR="$(cat /lib/uniberg/uconfig/system/label_mac)"

SETUP_SSID="$(cat /lib/uniberg/uconfig/system/hardware/wifi_ssid)"
SETUP_PASS="$(cat /lib/uniberg/uconfig/system/hardware/wifi_password)"

# Replace "%MACADDR%" and "%IP6ADDR%" in /lib/uniberg-uconfig/init-config-template.json

cp /lib/uniberg/uconfig/init-config-template.json /tmp/default.json

sed -i "s/%MACADDR%/$MACADDR/g" /tmp/default.json
sed -i "s/%IP6ADDR%/$IP6_ADDR/g" /tmp/default.json
sed -i "s/%SETUP_SSID%/$SETUP_SSID/g" /tmp/default.json
sed -i "s/%SETUP_PASS%/$SETUP_PASS/g" /tmp/default.json

cp /tmp/default.json /etc/uconfig/uniberg/factory.json
ln -s /etc/uconfig/uniberg/factory.json /etc/uconfig/uconfig.active

