#!/bin/sh

# Ping 8.8.8.8 in regular interval (60s) 4 times.
# Reboot if no response was received after 15 intervals (15 minutes).

TARGET="8.8.8.8"
INTERVAL=60
REBOOT_THRESHOLD=15


LOST_COUNTER=0

function reset_modem {
	# Check if files exist
	if [ ! -f /sys/class/gpio/modem_power/value ]; then
		return
	fi

	if [ ! -f /sys/class/gpio/modem_reset/value ]; then
		return
	fi

	echo "Resetting modem"
	echo 0 > /sys/class/gpio/modem_power/value
	sleep 2
	echo 1 > /sys/class/gpio/modem_reset/value
	sleep 2
	echo 0 > /sys/class/gpio/modem_reset/value
	sleep 2
}

while true; do
	ping -c 10 $TARGET > /dev/null
	if [ $? -ne 0 ]; then
		LOST_COUNTER=$((LOST_COUNTER+1))
		echo "No response from $TARGET, incrementing counter to $LOST_COUNTER"
	else
		if [ $LOST_COUNTER -gt 0 ]; then
			echo "Response from $TARGET, resetting counter"
			LOST_COUNTER=0
		fi
	fi

	if [ $LOST_COUNTER -ge $REBOOT_THRESHOLD ]; then
		echo "No response from $TARGET for 15 minutes, rebooting"

		# Shutting down modem
		reset_modem
		reboot
		LOST_COUNTER=0
	fi

	sleep $INTERVAL
done
