#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <errno.h>
#include <unistd.h>

#include <libubox/usock.h>

#include "announcement.h"
#include "log.h"

static void uconfigd_announcement_receive(struct uloop_fd *u, unsigned int events) {
	struct uconfigd_announcement *ad = container_of(u, struct uconfigd_announcement, fd);
	int fd = u->fd;
	char buf[1024];
	struct sockaddr_in6 addr;
	socklen_t addrlen = sizeof(addr);
	ssize_t len;
	uint64_t uuid;

	len = recvfrom(fd, buf, sizeof(buf), 0, (struct sockaddr *)&addr, &addrlen);
	if (len < 0) {
		perror("recvfrom");
		return;
	}

	buf[len] = '\0';
	MSG(INFO, "Received announcement: %s\n", buf);

	errno = 0;
	uuid = strtoull(buf, NULL, 10);
	if (errno) {
		perror("strtoull");
		return;
	}

	ad->config_uuid = uuid;

	return;
}

int uconfigd_announcement_start(struct uconfigd_announcement *ad)
{
	char port_str[6];
	struct ipv6_mreq group;
	int yes = 1;
	int fd;

	snprintf(port_str, sizeof(port_str), "%d", UCONFIGD_ANNOUNCEMENT_PORT);

	fd = usock(USOCK_UDP | USOCK_SERVER | USOCK_NONBLOCK |
		   USOCK_NUMERIC | USOCK_IPV6ONLY,
		   "::", port_str);
	if (fd < 0) {
		perror("usock");
		return fd;
	}

	if (!inet_pton(AF_INET6, UCONFIGD_ANNOUNCEMENT_GROUP, &group.ipv6mr_multiaddr.s6_addr))
		perror("inet_pton(AF_INET6)");

	/* Membership has to be added for every interface we listen on. */
	group.ipv6mr_interface = ad->ifindex;
	if(setsockopt(fd, IPPROTO_IPV6, IPV6_ADD_MEMBERSHIP, (char *)&group, sizeof group) < 0)
		perror("setsockopt(IPV6_ADD_MEMBERSHIP)");
	
	if (setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(yes)) < 0)
		perror("setsockopt(SO_REUSEADDR)");

	if (setsockopt(fd, SOL_SOCKET, SO_BROADCAST, &yes, sizeof(yes)) < 0)
		perror("setsockopt(SO_BROADCAST)");
	
	ad->fd.fd = fd;
	ad->fd.cb = uconfigd_announcement_receive;

	uloop_fd_add(&ad->fd, ULOOP_READ);

	return fd;
}

