#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <curl/curl.h>

#include "http.h"

struct uconfigd_http_data {
	char *buf;
	size_t buflen;
};

static char *uconfigd_http_read_file(const char *path)
{
	FILE *file;
	char *buf;
	long size;

	file = fopen(path, "r");
	if (!file) {
		return NULL;
	}

	fseek(file, 0, SEEK_END);
	size = ftell(file);
	fseek(file, 0, SEEK_SET);

	buf = calloc(1, size + 1);
	if (!buf) {
		fclose(file);
		return NULL;
	}

	if (fread(buf, 1, size, file) != size) {
		fclose(file);
		free(buf);
		return NULL;
	}

	buf[size] = '\0';
	fclose(file);

	return buf;
}

static int uconfigd_http_write_callback(char *ptr, size_t size, size_t nmemb, void *userdata)
{
	struct uconfigd_http_data *data = (struct uconfigd_http_data *)userdata;
	size_t len = size * nmemb;

	if (len > data->buflen) {
		len = data->buflen;
	}

	memcpy(data->buf, ptr, len);
	data->buf[len] = '\0';
	data->buflen -= len;
	data->buf += len;

	return len;
}

int uconfigd_http_post_file(const char *url, const char *file_path)
{
	char *file_data;
	long response_code = 0;

	file_data = uconfigd_http_read_file(file_path);
	if (!file_data) {
		fprintf(stderr, "Failed to read file %s\n", file_path);
		return -1;
	}

	response_code = uconfigd_http_post(url, file_data, NULL, 0);
	free(file_data);
	return response_code;
}

int uconfigd_http_post(const char *url, const char *data, char *buf, size_t buflen)
{
	CURL *curl;
	CURLcode res;
	long response_code = 0;
	int ret = -1;
	struct uconfigd_http_data http_data = { 
		.buf = buf,
		.buflen = buflen
	};

	curl = curl_easy_init();
	if(curl) {
		curl_easy_setopt(curl, CURLOPT_URL, url);
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS, data);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, uconfigd_http_write_callback);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &http_data);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);
		curl_easy_setopt(curl, CURLOPT_USERAGENT, "uconfigd/1.0");

		res = curl_easy_perform(curl);
		if(res != CURLE_OK) {
			ret = -1;
			goto out;
		}

		curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);
	}

	if (response_code != 200) {
		fprintf(stderr, "HTTP POST request failed with response code %ld\n", response_code);
	}

	ret = response_code;
out:
	curl_easy_cleanup(curl);
	return ret;
}

int uconfigd_http_get(const char *url, char *buf, size_t buflen)
{
	CURL *curl;
	CURLcode res;
	long response_code = 0;
	int ret = -1;
	struct uconfigd_http_data data = { 
		.buf = buf,
		.buflen = buflen
	};

	curl = curl_easy_init();
	if(curl) {
		curl_easy_setopt(curl, CURLOPT_URL, url);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, uconfigd_http_write_callback);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &data);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);
		curl_easy_setopt(curl, CURLOPT_USERAGENT, "uconfigd/1.0");

		res = curl_easy_perform(curl);
		if(res != CURLE_OK) {
			ret = -1;
			goto out;
		}

		curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);
	}

/*
	if (response_code != 200) {
		fprintf(stderr, "HTTP GET request failed with response code %ld\n", response_code);
	}
*/

	ret = response_code;
out:
	curl_easy_cleanup(curl);
	return ret;
}
