#include <stdio.h>
#include <stdarg.h>

#include "log.h"

enum log_debug_level debug_level = MSG_INFO;
int print_function_name = 1;

void log_level_set(int level)
{
	debug_level = level;
}

void debug_msg(int level, const char *func, int line, const char *format, ...)
{
	va_list ap;

	if (print_function_name)
		fprintf(stderr, "[%s:%d] ", func, line);

	va_start(ap, format);
	vfprintf(stderr, format, ap);
	va_end(ap);
}