#pragma once

#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define UCONFIGD_ETH_ALEN 6
#define UCONFIGD_ETH_STRLEN 18
#define UCONFIGD_ETH_STR_BUFLEN 19


static inline uint8_t *uconfigd_mac_address_bytes(const char *mac_address, uint8_t *bytes)
{
	sscanf(mac_address, "%hhx:%hhx:%hhx:%hhx:%hhx:%hhx",
	       &bytes[0], &bytes[1], &bytes[2],
	       &bytes[3], &bytes[4], &bytes[5]);

	return bytes;
}

static inline char *uconfigd_mac_address_string(const uint8_t *mac_address, char *mac_address_str)
{
	snprintf(mac_address_str, UCONFIGD_ETH_STR_BUFLEN,
		 "%02x:%02x:%02x:%02x:%02x:%02x",
		 mac_address[0], mac_address[1], mac_address[2],
		 mac_address[3], mac_address[4], mac_address[5]);

	return mac_address_str;
}
