#pragma once

#include <libubus.h>

enum uconfig_ubus_apply_state {
	UCONFIG_UBUS_APPLY_STATE_IDLE = 0,
	UCONFIG_UBUS_APPLY_STATE_PENDING_DOWNLOAD,
	UCONFIG_UBUS_APPLY_STATE_PENDING_APPLY,
	UCONFIG_UBUS_APPLY_STATE_APPLIED,
	UCONFIG_UBUS_APPLY_STATE_FAILED,
	UCONFIG_UBUS_APPLY_STATE_ERROR,
	UCONFIG_UBUS_APPLY_STATE_ADOPT,
};

struct uconfigd_ubus {
	struct ubus_context ctx;

	struct {
		enum uconfig_ubus_apply_state state;
		char uuid[128];
		uint64_t last_changed;
	} apply;
};

int uconfigd_ubus_start(struct uconfigd_ubus *uub);
int uconfigd_ubus_stop(struct uconfigd_ubus *uub);
