#pragma once

#include <stdint.h>

#include <netinet/in.h>
#include <libubox/uloop.h>

#include "announcement.h"
#include "mac.h"
#include "ubus.h"

#define UCONFIGD_STATE_MACHINE_TIMEOUT 2000
#define UCONFIGD_CONFIG_DOWNLOAD_INTERVAL 15 /* Seconds */

struct uconfigd_data {
	struct uconfigd_ubus ubus;
	struct uconfigd_announcement announcement;

	uint64_t config_uuid;
	uint8_t label_mac[UCONFIGD_ETH_ALEN];

	struct {
		uint64_t uptime_start;
		uint64_t uptime_current;
	} system;

	struct {
		struct uloop_timeout timeout;
	} state_machine;

	struct {
		uint64_t last_submission;
	} stats;
};