#include <string.h>
#include <curl/curl.h>

#include "http.h"
#include "log.h"

struct auther_http_data {
	char *buf;
	size_t buflen;
};

static int auther_http_write_callback(char *ptr, size_t size, size_t nmemb, void *userdata)
{
	struct auther_http_data *data = (struct auther_http_data *)userdata;
	size_t len = size * nmemb;

	if (len > data->buflen) {
		len = data->buflen;
	}

	memcpy(data->buf, ptr, len);
	data->buf[len] = '\0';
	data->buflen -= len;
	data->buf += len;

	return len;
}

int auther_http_post(const char *url, const char *data, char *buf, size_t buflen)
{
	CURL *curl;
	CURLcode res;
	long response_code = 0;
	int ret = -1;
	struct auther_http_data http_data = { 
		.buf = buf,
		.buflen = buflen
	};

	curl = curl_easy_init();
	if(curl) {
		curl_easy_setopt(curl, CURLOPT_URL, url);
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS, data);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, auther_http_write_callback);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &http_data);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);
		curl_easy_setopt(curl, CURLOPT_USERAGENT, "auther/1.0");

		res = curl_easy_perform(curl);
		if(res != CURLE_OK) {
			fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
			ret = -1;
			goto out;
		}

		curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);
	}

	if (response_code != 200) {
		MSG(ERROR, "HTTP POST request failed with response code %ld request=%s response=%s\n", response_code, data ? data : "", buf ? buf : "");
	}

	ret = response_code;
out:
	curl_easy_cleanup(curl);
	return ret;
}

int auther_http_get(const char *url, char *buf, size_t buflen)
{
	CURL *curl;
	CURLcode res;
	long response_code = 0;
	int ret = -1;
	struct auther_http_data data = { 
		.buf = buf,
		.buflen = buflen
	};

	curl = curl_easy_init();
	if(curl) {
		curl_easy_setopt(curl, CURLOPT_URL, url);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, auther_http_write_callback);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &data);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);
		curl_easy_setopt(curl, CURLOPT_USERAGENT, "auther/1.0");

		res = curl_easy_perform(curl);
		if(res != CURLE_OK) {
			fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
			ret = -1;
			goto out;
		}

		curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);
	}

	if (response_code != 200) {
		MSG(ERROR, "HTTP GET request failed with response code %ld\n", response_code);
	}

	ret = response_code;
out:
	curl_easy_cleanup(curl);
	return ret;
}