#pragma once

#include <stdarg.h>
#include <stdio.h>

enum log_debug_level {
	MSG_FATAL = 0,
	MSG_ERROR,
	MSG_WARN,
	MSG_INFO,
	MSG_VERBOSE,
	MSG_DEBUG,
};

#define MSG(_nr, _format, ...) log_msg(MSG_##_nr, __func__, __LINE__, _format, ##__VA_ARGS__)

void log_msg(int level, const char *func, int line, const char *format, ...);
void log_level_set(int level);
