#include <stdlib.h>

#include <libubox/uloop.h>

#include "auther.h"
#include "log.h"
#include "ubus.h"

static void auther_recurring_work(struct uloop_timeout *timeout)
{
	struct auther_data *auther_data = container_of(timeout, struct auther_data, recurring_timeout);

	auther_ubus_recurring_work(&auther_data->auther_ctx);
	uloop_timeout_set(timeout, AUTHER_RECURRING_TIMEOUT);
}

int main(int argc, char *argv[])
{
	struct auther_data auther_data = {};
	int ret;

	uloop_init();

	/* Set Log-Level */
	if (argc > 1) {
		log_level_set(atoi(argv[1]));
	}

	/* Register ubus */
	ret = auther_ubus_start(&auther_data.auther_ctx);
	if (ret) {
		MSG(ERROR, "Failed to start ubus\n");
		return ret;
	}

	/* Schedule recurring work */
	auther_data.recurring_timeout.cb = auther_recurring_work;
	uloop_timeout_set(&auther_data.recurring_timeout, 1);

	/* Run here */
	uloop_run();
	uloop_done();
	return 0;
}