#pragma once

#include <stdlib.h>
#include <time.h>

#include "sha256.h"

#define AUTHER_PERMISSION_CACHE_SIZE 32
#define AUTHER_PERMISSION_CACHE_TIMEOUT 60

struct auther_permission_cache_entry {
	char mac[18];
	char ssid[32];
	char psk[AUTHER_SHA256_DIGEST_BUFFER_LENGTH];
	int allowed;
	time_t timestamp;
};

struct auther_permission_data {
	struct auther_permission_cache_entry entries[AUTHER_PERMISSION_CACHE_SIZE];
};

struct auther_permission_request_data {
	const char *ssid;
	const char *mac;
	const char *psk;
};

int auther_permission_request(struct auther_permission_data *apd, const struct auther_permission_request_data *request);
