#pragma once

#include <stdlib.h>

#include <libubus.h>

#include <libubox/list.h>

#include "permission.h"

struct auther_ubus_hapd {
	struct list_head list;

	struct {
		char name[64];
		int id;
		struct ubus_subscriber subscriber;
	} ubus;
};

struct auther_ubus_ctx {
	struct ubus_context ctx;
	struct ubus_event_handler ubus_evh;

	struct auther_permission_data permission_data;

	struct list_head hapd_list;

	int pending_update;
};

int auther_ubus_recurring_work(struct auther_ubus_ctx *auther_ctx);
int auther_ubus_start(struct auther_ubus_ctx *auther_ctx);
