#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <json-c/json.h>

#include "collector.h"
#include "log.h"

static int collector_get_output(const char *cmd, char *buf, size_t buf_size)
{
	char tmp_buf[1024] = {};
	size_t read_bytes = 0;
	size_t returned_bytes;
	FILE *fp = NULL;
	int ret = 0;

	fp = popen(cmd, "r");
	if (!fp) {
		return -1;
	}

	while (fgets(tmp_buf, sizeof(tmp_buf), fp) != NULL) {
		returned_bytes = strnlen(tmp_buf, sizeof(tmp_buf));
		read_bytes += returned_bytes;
		if (read_bytes >= buf_size) {
			ret = -1;
			goto out;
		}

		memcpy(buf, tmp_buf, returned_bytes);
		buf = buf + returned_bytes;
	}

	buf[read_bytes] = '\0';

out:
	if (fp)
		pclose(fp);

	return ret;
}

static int collector_batman_cmd(struct json_object **jobj, const char *ifname, const char *cmd)
{
	char cmd_buf[1024] = {0};
	char buf[4096] = {0};
	int ret;

	snprintf(cmd_buf, sizeof(cmd_buf), "batctl %s %s 2>/dev/null", ifname, cmd);
	ret = collector_get_output(cmd_buf, buf, sizeof(buf));
	if (ret) {
		MSG_INFO("Failed to execute batctl command: %s\n", cmd_buf);
		return -1;
	}

	/* Parse JSON */
	*jobj = json_tokener_parse(buf);
	if (!*jobj) {
		MSG_INFO("Failed to parse batctl output %s\n");
		return -1;
	}

	return 0;
}

int collector_batman_mesh(struct json_object **jobj, const char *ifname)
{
	return collector_batman_cmd(jobj, ifname, "mj");
}

int collector_batman_neighbors(struct json_object **jobj, const char *ifname)
{
	return collector_batman_cmd(jobj, ifname, "nj");
}

int collector_batman_originators(struct json_object **jobj, const char *ifname)
{
	return collector_batman_cmd(jobj, ifname, "oj");
}

int collector_batman_interfaces(struct json_object **jobj, const char *ifname)
{
	return collector_batman_cmd(jobj, ifname, "hj");
}
