#pragma once

#include <stdarg.h>
#include <stdio.h>

enum log_debug_level {
	MSG_FATAL = 0,
	MSG_ERROR,
	MSG_WARN,
	MSG_INFO,
	MSG_VERBOSE,
	MSG_DEBUG,
};

#define MSG(_nr, _format, ...) debug_msg(MSG_##_nr, __func__, __LINE__, _format, ##__VA_ARGS__)
#define MSG_FATAL(_format, ...) MSG(FATAL, _format, ##__VA_ARGS__)
#define MSG_ERROR(_format, ...) MSG(ERROR, _format, ##__VA_ARGS__)
#define MSG_WARN(_format, ...) MSG(WARN, _format, ##__VA_ARGS__)
#define MSG_INFO(_format, ...) MSG(INFO, _format, ##__VA_ARGS__)
#define MSG_VERBOSE(_format, ...) MSG(VERBOSE, _format, ##__VA_ARGS__)
#define MSG_DEBUG(_format, ...) MSG(DEBUG, _format, ##__VA_ARGS__)

void statsd_log_level_set(int level);
void debug_msg(int level, const char *func, int line, const char *format, ...);
