#pragma once

#include <libubus.h>

#include <json-c/json.h>
#include <net/if.h>

struct statsd_ubus_hapd_instance {
	char name[16 + IF_NAMESIZE + 1];
	int id;
};

struct statsd_ubus {
	struct ubus_context ctx;

	struct {
		size_t count;
		struct statsd_ubus_hapd_instance instances[32];
	} hostapd_instances;
};

int statsd_ubus_start(struct statsd_ubus *uub);

int statsd_ubus_update_hostapd_instances(struct statsd_ubus *uub);

int statsd_ubus_hostapd_metrics(struct statsd_ubus *uub, struct json_object **jobj);