#!/bin/bash

for d in base/*; do
	if [ -d "$d" ]; then
		remote_url="$(git -C "$d" config --get remote.origin.url)"
		tracking_branch_name="master"

		if [[ "$remote_url" != *"git.uniberg.com"* ]]; then
			echo "Skipping submodule $d as origin is not located at git.uniberg.com - $remote_url"
			continue
		fi

		git -C "$d" fetch > /dev/null 2>&1

		if [ "$d" == "base/packages" ]; then
			# Skip packages
			echo "Skipping packages"
			continue
		fi

		# Check if branch $tracking_branch_name exists on origin
		if git -C "$d" ls-remote --exit-code origin "$tracking_branch_name" &> /dev/null; then
			tracking_branch_name="origin/$tracking_branch_name"
		elif [ "$d" == "base/os" ]; then
			tracking_branch_name="origin/openwrt-24.10-uniberg"
		elif [ "$d" == "base/uconfig" ]; then
			tracking_branch_name="origin/uniberg"
		else
			tracking_branch_name="origin/main"
		fi
		
		git -C "$d" fetch

		# Get git hash
		git_hash="$(git -C "$d" rev-parse HEAD)"

		# Check if HEAD equals tracking branch
		if [ "$git_hash" == "$(git -C "$d" rev-parse $tracking_branch_name)" ]; then
			echo "Submodule $d is up to date with $tracking_branch_name"
			continue
		fi

		commits_ahead="$(git -C "$d" rev-list --count $tracking_branch_name..HEAD)"
		commits_behind="$(git -C "$d" rev-list --count HEAD..$tracking_branch_name)"

		if [ "$commits_behind" -ne 0 ]; then
			echo "Submodule $d is $commits_behind commits behind $tracking_branch_name"
		fi

		if [ "$commits_ahead" -ne 0 ]; then
			echo "Submodule $d is $commits_ahead commits ahead $tracking_branch_name"
		fi
	fi
done