#!/bin/bash

set -xe

RELEASE_NAME="$1"
RELEASE_BRANCH_NAME="release-$RELEASE_NAME"
BRANCHOFF_TAG_NAME="release-$RELEASE_NAME-branchoff"
SIMULATE=false

if [ -z "$RELEASE_NAME" ]; then
	echo "Usage: $0 <release-name>"
	exit 1
fi

# Check for all submoduels in folder base if origin is located at "git.uniberg.com".
# If origin is located there, create a new branch with $RELEASE_BRANCH_NAME.
# Push this branch to the origin.

exec_git() {
	if [ "$SIMULATE" = true ]; then
		echo "git $@"
		return
	else
		git "$@"
	fi
}

create_tag_subdir() {
	local subdir="$1"

	echo "Creating branch $RELEASE_BRANCH_NAME in $subdir"
	exec_git -C "$subdir" checkout -b "$RELEASE_BRANCH_NAME"
	exec_git -C "$subdir" push origin "$RELEASE_BRANCH_NAME"

	echo "Creating Tag for branchoff $BRANCHOFF_TAG_NAME"
	exec_git -C "$subdir" tag -a "$BRANCHOFF_TAG_NAME" -m "Tag for branchoff $RELEASE_BRANCH_NAME"
	exec_git -C "$subdir" push origin "$BRANCHOFF_TAG_NAME"

}

for d in base/*; do
	if [ -d "$d" ]; then
		remote_url="$(git -C "$d" config --get remote.origin.url)"

		# Only create Freeze-branches and tags for local repositories
		if [[ "$remote_url" == *"git.uniberg.com"* ]]; then
			echo "Found submodule in $d with URL $remote_url"
			create_tag_subdir "$d"
		fi
	fi
done

# Create branch from current directory
create_tag_subdir "."
