#!/bin/sh

s='

AT+QSCAN=3,1

+QSCAN: "LTE",<MCC>,<MNC>,<freq>,<PCI>,<RSRP>,<RSRQ>,<srxlev>,<squal>[,<cellID>,<TAC>] …]
[+QSCAN: "NR5G",<MCC>,<MNC>,<freq>,<PCI>,<RSRP>,<RSRQ>,<srxlev>,<scs>[,<cellID>,<TAC>,<bandwidth>,<band>]
…]

scs is false. (proof: scs stays at 15khz even though it has to be 30khz for the larger (>50Mhz) FR1 channels.)
"bandwidth" is actually RBs (radio bearers).
'

s=$1
[ -z "$s" ] && s=qtscan

sed 's/.*LTE"/LTE/; s/.*NR5G"/5G/' $s | 
sort -t"," -n -k6 | 
awk -F, '{
bandwidth=$12
if($1=="LTE"){
	s="scs=15khz squal="$9; 
	if(bandwidth==25)
		b=5
	if(bandwidth==50)
		b=10
	if(bandwidth==75)
		b=15
	if(bandwidth==100)
		b=20
}
if($1=="5G"){
	scs=$9
	if(scs==0)
		s="15khz"
	if(scs==1)
		s="30khz"
	if(scs==2)
		s="60khz"
	if(scs==3)
		s="120khz"
	split("25 52 79 106 133 160 188 216 242 270", scs15, " ")
	split("11 24 38 51 65 78 92 106 119 133 162 189 217 245 273", scs30, " ")
	bw=0
	b=0
	if(s=="15khz")
		for(rb in scs15){
			b+=5
			if(scs15[rb]==bandwidth)
				break;
		}
	if(s=="30khz")
		for(rb in scs30){
			b+=5
			if(scs30[rb]==bandwidth)
				break;
		}
	s="scs="s
}; 
print "tech="$1, "plmn="$2$3, "aerfcn="$4, "pci="$5, "rsrp="$6, "rsrq="$7, "srxlev="$8, "cellid="$10, "tac="$11, "bw="b, "band="$13, s, $14, $15, $16, $17
}' | column -t
