json = require "luci.jsonc"


local function execute_command(command)
    local f = io.popen(command, 'r')
    if not f then
        return nil, "Failed to execute command: " .. command
    end
    local output = f:read('*all')
    f:close()
    return output
end

local function batctl_mesh()
    local command = "batctl batman mj"
    --{"version":"2024.3-openwrt-2","algo_name":"BATMAN_IV","mesh_ifindex":23,"mesh_ifname":"batman","mesh_address":"fa:6e:97:51:86:53","hard_ifindex":27,"hard_ifname":"phy0-mesh0","hard_address":"26:97:27:53:9a:21","tt_ttvn":2,"bla_crc":50722,"mcast_flags":{"all_unsnoopables": false,"want_all_ipv4": false,"want_all_ipv6": false,"want_no_rtr_ipv4": true,"want_no_rtr_ipv6": true,"have_mc_ptype_capa": true,"raw": 56},"mcast_flags_priv":{"bridged": false,"querier_ipv4_exists": false,"querier_ipv6_exists": false,"querier_ipv4_shadowing": false,"querier_ipv6_shadowing": false,"raw": 0},"aggregated_ogms_enabled":true,"ap_isolation_enabled":false,"isolation_mark":0,"isolation_mask":0,"bonding_enabled":false,"bridge_loop_avoidance_enabled":true,"distributed_arp_table_enabled":false,"fragmentation_enabled":true,"gw_bandwidth_down":100,"gw_bandwidth_up":20,"gw_mode":"off","gw_sel_class":20,"hop_penalty":30,"multicast_forceflood_enabled":true,"orig_interval":5000,"multicast_fanout":16}
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_batctl_aggregated_ogms_enabled = metric("batctl_aggregated_ogms_enabled", "gauge")
    local metric_batctl_ap_isolation_enabled = metric("batctl_ap_isolation_enabled", "gauge")
    local metric_batctl_isolation_mark = metric("batctl_isolation_mark", "gauge")
    local metric_batctl_isolation_mask = metric("batctl_isolation_mask", "gauge")
    local metric_batctl_bonding_enabled = metric("batctl_bonding_enabled", "gauge")
    local metric_batctl_bridge_loop_avoidance_enabled = metric("batctl_bridge_loop_avoidance_enabled", "gauge")
    local metric_batctl_distributed_arp_table_enabled = metric("batctl_distributed_arp_table_enabled", "gauge")
    local metric_batctl_fragmentation_enabled = metric("batctl_fragmentation_enabled", "gauge")
    local metric_batctl_gw_bandwidth_down = metric("batctl_gw_bandwidth_down", "gauge")
    local metric_batctl_gw_bandwidth_up = metric("batctl_gw_bandwidth_up", "gauge")
    local metric_batctl_gw_mode = metric("batctl_gw_mode", "gauge")
    local metric_batctl_gw_sel_class = metric("batctl_gw_sel_class", "gauge")
    local metric_batctl_hop_penalty = metric("batctl_hop_penalty", "gauge")
    local metric_batctl_multicast_forceflood_enabled = metric("batctl_multicast_forceflood_enabled", "gauge")
    local metric_batctl_orig_interval = metric("batctl_orig_interval", "gauge")
    local metric_batctl_multicast_fanout = metric("batctl_multicast_fanout", "gauge")

    local labels = { device= "batman", type = "mesh", mesh_ifname = json_data.mesh_ifname, mesh_address = json_data.mesh_address, hard_ifname = json_data.hard_ifname, hard_address = json_data.hard_address }

    metric_batctl_aggregated_ogms_enabled(labels, json_data.aggregated_ogms_enabled and 1 or 0)
    metric_batctl_ap_isolation_enabled(labels, json_data.ap_isolation_enabled and 1 or 0)
    metric_batctl_isolation_mark(labels, json_data.isolation_mark)
    metric_batctl_isolation_mask(labels, json_data.isolation_mask)
    metric_batctl_bonding_enabled(labels, json_data.bonding_enabled and 1 or 0)
    metric_batctl_bridge_loop_avoidance_enabled(labels, json_data.bridge_loop_avoidance_enabled and 1 or 0)
    metric_batctl_distributed_arp_table_enabled(labels, json_data.distributed_arp_table_enabled and 1 or 0)
    metric_batctl_fragmentation_enabled(labels, json_data.fragmentation_enabled and 1 or 0)
    metric_batctl_gw_bandwidth_down(labels, json_data.gw_bandwidth_down)
    metric_batctl_gw_bandwidth_up(labels, json_data.gw_bandwidth_up)
    metric_batctl_gw_mode(labels, json_data.gw_mode == "off" and 0 or 1)
    metric_batctl_gw_sel_class(labels, json_data.gw_sel_class)
    metric_batctl_hop_penalty(labels, json_data.hop_penalty )
    metric_batctl_multicast_forceflood_enabled(labels, json_data.multicast_forceflood_enabled and 1 or 0)
    metric_batctl_orig_interval(labels, json_data.orig_interval)
    metric_batctl_multicast_fanout(labels, json_data.multicast_fanout)
end

local function batctl_bla_backbone()
    local command = "batctl batman bbj"
    -- [{"last_seen_msecs":4290,"bla_own":true,"bla_vid":11,"bla_backbone":"26:97:27:53:9a:21","bla_crc":0}]
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_batctl_last_seen_msecs = metric("batctl_last_seen_msecs", "gauge")
    local metric_batctl_bla_own = metric("batctl_bla_own", "gauge")

    for _, data in pairs(json_data) do
        local labels = { device= "batman", type = "backbone", bla_vid = data.bla_vid, bla_backbone = data.bla_backbone }
        metric_batctl_last_seen_msecs(labels, data.last_seen_msecs)
        metric_batctl_bla_own(labels, data.bla_own and 1 or 0)
    end

end

local function batctl_hardif()
    local command = "batctl batman hj"
    -- [{"mesh_ifindex":23,"mesh_ifname":"batman","hard_ifindex":3,"hard_ifname":"lan1","hard_address":"20:97:27:53:9a:1f","active":true,"hop_penalty":0,"elp_interval":500,"throughput_override":0}]
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_batctl_active = metric("batctl_active", "gauge")
    local metric_batctl_hop_penalty = metric("batctl_hop_penalty", "gauge")
    local metric_batctl_elp_interval = metric("batctl_elp_interval", "gauge")
    local metric_batctl_throughput_override = metric("batctl_throughput_override", "gauge")

    for _, data in pairs(json_data) do
        local labels = { device= "batman", type = "hardif", mesh_ifname = data.mesh_ifname, mesh_ifindex = data.mesh_ifindex, hard_ifname = data.hard_ifname, hard_ifindex = data.hard_ifindex, hard_address = data.hard_address}
        metric_batctl_active(labels, data.active and 1 or 0)
        metric_batctl_hop_penalty(labels, data.hop_penalty)
        metric_batctl_elp_interval(labels, data.elp_interval)
        metric_batctl_throughput_override(labels, data.throughput_override)
    end

end

local function batctl_mcast_flags()
    local command = "batctl batman mfj"
    -- [{"orig_address":"f4:4d:5c:fe:76:27","mcast_flags":{"all_unsnoopables": false,"want_all_ipv4": false,"want_all_ipv6": false,"want_no_rtr_ipv4": true,"want_no_rtr_ipv6": true,"have_mc_ptype_capa": true,"raw": 56}}]
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_batctl_all_unsnoopables = metric("batctl_all_unsnoopables", "gauge")
    local metric_batctl_want_all_ipv4 = metric("batctl_want_all_ipv4", "gauge")
    local metric_batctl_want_all_ipv6 = metric("batctl_want_all_ipv6", "gauge")
    local metric_batctl_want_no_rtr_ipv4 = metric("batctl_want_no_rtr_ipv4", "gauge")
    local metric_batctl_want_no_rtr_ipv6 = metric("batctl_want_no_rtr_ipv6", "gauge")
    local metric_batctl_have_mc_ptype_capa = metric("batctl_have_mc_ptype_capa", "gauge")

    for _, data in pairs(json_data) do
        local flags = data.mcast_flags
        local labels = { device = "batman", type = "mcast_flags", orig_address = data.orig_address }

        metric_batctl_all_unsnoopables(labels, flags.all_unsnoopables and 1 or 0)
        metric_batctl_want_all_ipv4(labels, flags.want_all_ipv4 and 1 or 0)
        metric_batctl_want_all_ipv6(labels, flags.want_all_ipv6 and 1 or 0)
        metric_batctl_want_no_rtr_ipv4(labels, flags.want_no_rtr_ipv4 and 1 or 0)
        metric_batctl_want_no_rtr_ipv6(labels, flags.want_no_rtr_ipv6 and 1 or 0)
        metric_batctl_have_mc_ptype_capa(labels, flags.have_mc_ptype_capa and 1 or 0)
    end

end

local function batctl_neighbors()
    local command = "batctl batman nj"
    -- [{"hard_ifindex":3,"hard_ifname":"lan1","last_seen_msecs":4290,"neigh_address":"f4:4d:5c:fe:76:27"},{"hard_ifindex":4,"hard_ifname":"lan2","last_seen_msecs":4030,"neigh_address":"f4:4d:5c:fe:76:42"}]
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_batctl_last_seen_msecs = metric("batctl_last_seen_msecs", "gauge")

    for _, data in pairs(json_data) do
        local labels = { device = "batman", type = "neighbors", hard_ifindex = data.hard_ifindex, hard_ifname = data.hard_ifname, neigh_address = data.neigh_address}
        metric_batctl_last_seen_msecs(labels, data.last_seen_msecs)
    end

end

local function batctl_originators()
    local command = "batctl batman oj"
    -- [{"hard_ifindex":4,"hard_ifname":"lan2","orig_address":"f4:4d:5c:fe:76:27","last_seen_msecs":4010,"neigh_address":"f4:4d:5c:fe:76:42","tq":220},{"hard_ifindex":3,"hard_ifname":"lan1","orig_address":"f4:4d:5c:fe:76:27","best":true,"last_seen_msecs":4010,"neigh_address":"f4:4d:5c:fe:76:27","tq":255}]
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_batctl_last_seen_msecs = metric("batctl_last_seen_msecs", "gauge")
    local metric_batctl_best = metric("batctl_best", "gauge")
    local metric_batctl_tq = metric("batctl_tq", "gauge")

    for _, data in pairs(json_data) do
        local labels = { device = "batman", type = "originators", hard_ifindex = data.hard_ifindex, hard_ifname = data.hard_ifname, orig_address = data.orig_address, neigh_address = data.neigh_address}
        metric_batctl_last_seen_msecs(labels, data.last_seen_msecs)
        metric_batctl_best(labels, data.best and 1 or 0)
        metric_batctl_tq(labels, data.tq)
    end

end

local function batctl_transtable_global()
    local command = "batctl batman tgj"
    -- [{"orig_address":"f6:4d:5c:fe:76:43","tt_address":"da:11:be:df:30:06","tt_ttvn":1,"tt_last_ttvn":1,"tt_crc32":3957051624,"tt_vid":3,"tt_flags":{"del": false,"roam": false,"wifi": false,"isolated": false,"nopurge": false,"new": false,"pending": false,"temp": false,"raw": 0},"best":true}]
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_batctl_tt_ttvn = metric("batctl_tt_ttvn", "gauge")
    local metric_batctl_tt_last_ttvn = metric("batctl_tt_last_ttvn", "gauge")
    local metric_batctl_best = metric("batctl_best", "gauge")
    -- flags
    local metric_tt_flag_del = metric("batctl_tt_flag_del", "gauge")
    local metric_tt_flag_roam = metric("batctl_tt_flag_roam", "gauge")
    local metric_tt_flag_wifi = metric("batctl_tt_flag_wifi", "gauge")
    local metric_tt_flag_isolated = metric("batctl_tt_flag_isolated", "gauge")
    local metric_tt_flag_nopurge = metric("batctl_tt_flag_nopurge", "gauge")
    local metric_tt_flag_new = metric("batctl_tt_flag_new", "gauge")
    local metric_tt_flag_pending = metric("batctl_tt_flag_pending", "gauge")
    local metric_tt_flag_temp = metric("batctl_tt_flag_temp", "gauge")

    for _, data in pairs(json_data) do
        local labels = { device = "batman", type = "transtable_global", orig_address = data.orig_address, tt_address = data.tt_address, tt_vid = data.tt_vid }
        local flags = data.tt_flags
        metric_batctl_tt_ttvn(labels, data.tt_ttvn)
        metric_batctl_tt_last_ttvn(labels, data.tt_last_ttvn)
        metric_batctl_best(labels, data.best and 1 or 0)
        metric_tt_flag_del(labels, flags.del and 1 or 0)
        metric_tt_flag_roam(labels, flags.roam and 1 or 0)
        metric_tt_flag_wifi(labels, flags.wifi and 1 or 0)
        metric_tt_flag_isolated(labels, flags.isolated and 1 or 0)
        metric_tt_flag_nopurge(labels, flags.nopurge and 1 or 0)
        metric_tt_flag_new(labels, flags["new"] and 1 or 0)
        metric_tt_flag_pending(labels, flags.pending and 1 or 0)
        metric_tt_flag_temp(labels, flags.temp and 1 or 0)
    end

end

local function batctl_transtable_local()
    local command = "batctl batman tlj"
    -- [{"tt_address":"76:b4:f6:0e:d3:40","tt_crc32":988791288,"tt_vid":0,"tt_flags":{"del": false,"roam": false,"wifi": false,"isolated": false,"nopurge": true,"new": false,"pending": false,"temp": false,"raw": 256}}]
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_tt_last_seen = metric("batctl_tt_last_seen_msecs", "gauge")
    -- flags
    local metric_tt_flag_del = metric("batctl_tt_flag_del", "gauge")
    local metric_tt_flag_roam = metric("batctl_tt_flag_roam", "gauge")
    local metric_tt_flag_wifi = metric("batctl_tt_flag_wifi", "gauge")
    local metric_tt_flag_isolated = metric("batctl_tt_flag_isolated", "gauge")
    local metric_tt_flag_nopurge = metric("batctl_tt_flag_nopurge", "gauge")
    local metric_tt_flag_new = metric("batctl_tt_flag_new", "gauge")
    local metric_tt_flag_pending = metric("batctl_tt_flag_pending", "gauge")
    local metric_tt_flag_temp = metric("batctl_tt_flag_temp", "gauge")

    for _, data in pairs(json_data) do
        local labels = { device = "batman", type = "transtable_local", tt_address = data.tt_address, tt_vid = data.tt_vid }
        local flags = data.tt_flags
        metric_tt_last_seen(labels, data.last_seen_msecs or 0)
        metric_tt_flag_del(labels, flags.del and 1 or 0)
        metric_tt_flag_roam(labels, flags.roam and 1 or 0)
        metric_tt_flag_wifi(labels, flags.wifi and 1 or 0)
        metric_tt_flag_isolated(labels, flags.isolated and 1 or 0)
        metric_tt_flag_nopurge(labels, flags.nopurge and 1 or 0)
        metric_tt_flag_new(labels, flags["new"] and 1 or 0)
        metric_tt_flag_pending(labels, flags.pending and 1 or 0)
        metric_tt_flag_temp(labels, flags.temp and 1 or 0)
    end

end

local function batctl_statistics()
    local output = execute_command("batctl batman s")
    local device_label = { device = "batman", type = "statistics" }

    for data in output:gmatch("[^\r\n]+") do
        -- remove whitespaces
        local stat = data:match("^%s*(.-)%s*$")
        -- extract key: value
        local key, value = stat:match("([^:]+):%s*(%d+)")

        if key and value then
            -- Define metrics
            local metric_name = "batctl_stat_" .. key
            local m = metric(metric_name, "gauge")
            m(device_label, tonumber(value))
        end
    end
end

local function scrape()
    batctl_mesh()
    batctl_bla_backbone()
    batctl_hardif()
    batctl_mcast_flags()
    batctl_neighbors()
    batctl_originators()
    batctl_transtable_global()
    batctl_transtable_local()
    batctl_statistics()
end

-- schmeiss raus
return { scrape = scrape }