#!/bin/bash

CONTROLLA="root@192.168.201.26"

give_metrics()
{
    ssh $CONTROLLA curl --silent localhost/metrics | grep -E 'uqmi|batctl'
}

if [ "$1" == "m" ]; then
    give_metrics
    exit 0
fi

echo "Copy locker script to controlla"
rsync locker.sh $CONTROLLA:/tmp/.

echo "copy uqmi.lua & batctl.lua to the controlla"
rsync uqmi.lua $CONTROLLA:/usr/lib/lua/prometheus-collectors/.
rsync batctl.lua $CONTROLLA:/usr/lib/lua/prometheus-collectors/.

# Lock
ssh $CONTROLLA "/tmp/locker.sh"

echo "restart node exporter on controlla"
ssh $CONTROLLA /etc/init.d/prometheus-node-exporter-lua restart

# Unlock
ssh $CONTROLLA "/tmp/locker.sh unlock"

echo "check output"
give_metrics
exit 0
