json = require "luci.jsonc"


local function execute_command(command)
    local f = io.popen(command, 'r')
    if not f then
        return nil, "Failed to execute command: " .. command
    end
    local output = f:read('*all')
    f:close()
    return output
end


local function uqmi_signal_info()
    local command = "uqmi -d /dev/cdc-wdm0 --get-signal"
    --    {
    -- "type": "lte",
    -- "rssi": -77,
    -- "rsrq": -11,
    -- "rsrp": -109,
    -- "snr": 6.000000
    --    }
    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- ersma hier die metriken definieren
    local metric_uqmi_signal_rssi_dbm = metric("uqmi_signal_rssi_dbm", "gauge")
    local metric_uqmi_signal_rsrq_dbm = metric('uqmi_signal_rsrq_dbm', 'gauge')
    local metric_uqmi_signal_rsrp_dbm = metric('uqmi_signal_rsrp_dbm', 'gauge')
    local metric_uqmi_signal_snr = metric('uqmi_signal_snr', 'gauge')

    -- labels aller

    local labels = {
        type = json_data.type
    }

    -- data inne metrik rein
    metric_uqmi_signal_rssi_dbm(labels, json_data.rssi)
    metric_uqmi_signal_rsrp_dbm(labels, json_data.rsrp)
    metric_uqmi_signal_rsrq_dbm(labels, json_data.rsrq)
    metric_uqmi_signal_snr(labels, json_data.snr)
end

local function uqmi()
    local command = "uqmi -d /dev/cdc-wdm0 --get-serving-system"
    --    {
    -- "registration": "registered",
    -- "radio_interface": [
    -- 	"lte"
    -- ],
    -- "plmn_mcc": 262,
    -- "plmn_mnc": 3,
    -- "plmn_description": "o2 - de",
    -- "roaming": false
    --    }
    local json_output = execute_command(command)
    local data = json.parse(json_output)

    -- ersma hier die metriken definieren
    local metric_uqmi_registration = metric("uqmi_registration", "gauge")
    local metric_uqmi_plmn_mcc = metric('uqmi_plmn_mcc', 'gauge')
    local metric_uqmi_plmn_mnc = metric('uqmi_plmn_mnc', 'gauge')
    local metric_uqmi_roaming = metric('uqmi_roaming', 'gauge')

    local labels = {
        type = "lte" -- ist gelogen muss ausgelesen werden, steht in data.radio_interface
    }
    local registration
    if data.registration == "registered" then
        registration = 1
    else
        registration = 0
    end

    local roaming = tonumber(data.roaming)
    if roaming then
        roaming = 1
    else
        roaming = 0
    end

    -- data inne metrik rein
    metric_uqmi_registration(labels, registration)
    metric_uqmi_plmn_mcc(labels, data.plmn_mcc)
    metric_uqmi_plmn_mnc(labels, data.plmn_mnc)
    metric_uqmi_roaming(labels, roaming)
end

local function uqmi_system_info()
    local command = "uqmi -d /dev/cdc-wdm0 --get-system-info"
    -- root@209727539a1f:/usr/lib/lua/prometheus-collectors# uqmi -d /dev/cdc-wdm0 --get-system-info
    -- {
    -- 	"wcdma": {
    -- 		"service_status": "none",
    -- 		"true_service_status": "none",
    -- 		"preferred_data_path": false
    -- 	},
    -- 	"lte": {
    -- 		"service_status": "available",
    -- 		"true_service_status": "available",
    -- 		"preferred_data_path": false,
    -- 		"domain": "cs-ps",
    -- 		"service": "cs-ps",
    -- 		"roaming_status": "off",
    -- 		"forbidden": false,
    -- 		"mcc": "262",
    -- 		"mnc": "03",
    -- 		"tracking_area_code": 11062,
    -- 		"enodeb_id": 13217,
    -- 		"cell_id": 39,
    -- 		"voice_support": true,
    -- 		"ims_voice_support": true,
    -- 		"cell_access_status": "all calls",
    -- 		"registration_restriction": 0,
    -- 		"registration_domain": 0,
    -- 		"5g_nsa_available": true,
    -- 		"dcnr_restriction": false
    -- 	},
    -- 	"5gnr": {
    -- 		"service_status": "none",
    -- 		"true_service_status": "none",
    -- 		"preferred_data_path": false
    -- 	}
    -- }
    local json_output = execute_command(command)
    local data = json.parse(json_output)

    -- define metrics
    local metric_uqmi_roaming_status = metric('uqmi_roaming_status', 'gauge')
    local metric_uqmi_forbidden = metric('uqmi_forbidden', 'gauge')
    local metric_uqmi_mcc = metric("uqmi_mcc", "gauge")
    local metric_uqmi_mnc = metric("uqmi_mnc", "gauge")
    local metric_uqmi_tracking_area_code = metric("uqmi_tracking_area_code", "gauge")
    local metric_uqmi_enodeb_id = metric("uqmi_enodeb_id", "gauge")
    local metric_uqmi_cell_id = metric("uqmi_cell_id", "gauge")
    local metric_uqmi_voice_support = metric("uqmi_voice_support", "gauge")
    local metric_uqmi_ims_voice_support = metric("uqmi_ims_voice_support", "gauge")
    local metric_uqmi_registration_domain = metric("uqmi_registration_domain", "gauge")
    local metric_uqmi_registration_restriction = metric("uqmi_registration_restriction", "gauge")

    local lte = data.lte or {}
    local labels = { type = "lte" }

    metric_uqmi_roaming_status(labels, lte.roaming_status == "off" and 0 or 1)
    metric_uqmi_forbidden(labels, lte.forbidden and 1 or 0)
    metric_uqmi_mcc(labels, lte.mcc)
    metric_uqmi_mnc(labels, lte.mnc)
    metric_uqmi_tracking_area_code(labels, lte.tracking_area_code)
    metric_uqmi_enodeb_id(labels, lte.enodeb_id)
    metric_uqmi_cell_id(labels, lte.cell_id)
    metric_uqmi_voice_support(labels, lte.voice_support and 1 or 0)
    metric_uqmi_ims_voice_support(labels, lte.ims_voice_support and 1 or 0)
    metric_uqmi_registration_domain(labels, lte.registration_domain)
    metric_uqmi_registration_restriction(labels, lte.registration_restriction)
end

local function uqmi_get_tx_rx_info()
    local command = "uqmi -d /dev/cdc-wdm0  --get-tx-rx-info lte"
    -- "rx_chain_0": {
	-- 	"tuned": true,
	-- 	"rssi": -76.300000,
	-- 	"rsrq": 14.500000,
	-- 	"rsrp": 110.700000,
	-- 	"phase": 0.000000
	-- },
	-- "rx_chain_1": {
	-- 	"tuned": true,
	-- 	"rssi": -76.700000,
	-- 	"rsrq": 13.100000,
	-- 	"rsrp": 109.800000,
	-- 	"phase": 0.000000
	-- },
	-- "rx_chain_2": {
	-- 	"tuned": true,
	-- 	"rssi": -82.500000,
	-- 	"rsrq": 14.600000,
	-- 	"rsrp": 117.100000,
	-- 	"phase": 0.000000
	-- },
	-- "rx_chain_3": {
	-- 	"tuned": true,
	-- 	"rssi": -76.400000,
	-- 	"rsrq": 14.700000,
	-- 	"rsrp": 111.100000,
	-- 	"phase": 0.000000
	-- },
	-- "tx": {
	-- 	"traffic": true,
	-- 	"tx_power": 23.000000
	-- }

    local json_output = execute_command(command)
    local json_data = json.parse(json_output)

    -- define metrics
    local metric_uqmi_rx_rssi = metric("uqmi_rx_rssi", "gauge")
    local metric_uqmi_rx_rsrq = metric("uqmi_rx_rsrq", "gauge")
    local metric_uqmi_rx_rsrp = metric("uqmi_rx_rsrp", "gauge")
    local metric_uqmi_rx_phase = metric("uqmi_rx_phase", "gauge")
    local metric_uqmi_rx_tuned = metric("uqmi_rx_tuned", "gauge")
    local metric_uqmi_tx_power = metric("uqmi_tx_power", "gauge")
    local metric_uqmi_tx_traffic = metric("uqmi_tx_traffic", "gauge")

    for key, data in pairs(json_data) do
        if key:match("^rx_chain_%d+$") then
            local chain_id = key:match("(%d+)$")
            local labels = { type = "lte", chain = chain_id }

            metric_uqmi_rx_rssi(labels, data.rssi)
            metric_uqmi_rx_rsrq(labels, data.rsrq)
            metric_uqmi_rx_rsrp(labels, data.rsrp)
            metric_uqmi_rx_phase(labels, data.phase)
            metric_uqmi_rx_tuned(labels, data.tuned and 1 or 0)
        end
    end

    if json_data.tx then
        local labels = { type = "lte" }
        metric_uqmi_tx_power(labels, json_data.tx.tx_power)
        metric_uqmi_tx_traffic(labels, json_data.tx.traffic and 1 or 0)
    end
end

local function scrape()
    uqmi_signal_info()
    uqmi()
    uqmi_system_info()
    uqmi_get_tx_rx_info()
end

-- schmeiss raus
return { scrape = scrape }
