#!/bin/sh

#-    author          Arthur Koch
#-    date            07.07.2025

UQMI="uqmi"
DEVICE="/dev/cdc-wdm0"


TEXTFILE_COLLECTOR_DIR="/var/prometheus/" 
TMP_METRICS_FILE="${TEXTFILE_COLLECTOR_DIR}/uqmi_signal.prom.$$"
FINAL_METRICS_FILE="${TEXTFILE_COLLECTOR_DIR}/uqmi_signal.prom"

mkdir -p "${TEXTFILE_COLLECTOR_DIR}"

# --- Metric Definitions ---

# HELP for uqmi_signal_rssi_dbm
echo '# HELP uqmi_signal_rssi_dbm Received Signal Strength Indicator in dBm.' > "${TMP_METRICS_FILE}"
echo '# TYPE uqmi_signal_rssi_dbm gauge' >> "${TMP_METRICS_FILE}"

# HELP for uqmi_signal_rsrq_db
echo '# HELP uqmi_signal_rsrq_db Reference Signal Received Quality in dB.' >> "${TMP_METRICS_FILE}"
echo '# TYPE uqmi_signal_rsrq_db gauge' >> "${TMP_METRICS_FILE}"

# HELP for uqmi_signal_rsrp_dbm
echo '# HELP uqmi_signal_rsrp_dbm Reference Signal Received Power in dBm.' >> "${TMP_METRICS_FILE}"
echo '# TYPE uqmi_signal_rsrp_dbm gauge' >> "${TMP_METRICS_FILE}"

# HELP for uqmi_signal_snr_db
echo '# HELP uqmi_signal_snr_db Signal to Noise Ratio in dB.' >> "${TMP_METRICS_FILE}"
echo '# TYPE uqmi_signal_snr_db gauge' >> "${TMP_METRICS_FILE}"

# HELP for uqmi_signal_info_up
echo '# HELP uqmi_signal_info_up UQMI signal info collection status (1 if successful, 0 if failed).' >> "${TMP_METRICS_FILE}"
echo '# TYPE uqmi_signal_info_up gauge' >> "${TMP_METRICS_FILE}"

# --- Collect Data ---

UQMI_OUTPUT="$(${UQMI} -d "${DEVICE}" --get-signal-info 2>/dev/null)"
UQMI_EXIT_CODE=$?

if [ ${UQMI_EXIT_CODE} -ne 0 ] || [ -z "${UQMI_OUTPUT}" ]; then
    echo "Warning: uqmi command failed or returned empty output. Exit code: ${UQMI_EXIT_CODE}" >&2
    echo "uqmi_signal_info_up 0" >> "${TMP_METRICS_FILE}"
else

    echo "uqmi_signal_info_up 1" >> "${TMP_METRICS_FILE}"

  echo "${UQMI_OUTPUT}" | jsonfilter -l 1 -e '@' | while IFS= read -r signal_obj; do
        SIGNAL_TYPE=$(echo "${signal_obj}" | jsonfilter -e '@.type' 2>/dev/null)
        
        if [ -n "${SIGNAL_TYPE}" ]; then
            RSSI=$(echo "${signal_obj}" | jsonfilter -e '@.rssi' 2>/dev/null)
            RSRQ=$(echo "${signal_obj}" | jsonfilter -e '@.rsrq' 2>/dev/null)
            RSRP=$(echo "${signal_obj}" | jsonfilter -e '@.rsrp' 2>/dev/null)
            SNR=$(echo "${signal_obj}" | jsonfilter -e '@.snr' 2>/dev/null)

            [ -n "${RSSI}" ] && echo "uqmi_signal_rssi_dbm{type=\"${SIGNAL_TYPE}\", device=\"${DEVICE}\"} ${RSSI}" >> "${TMP_METRICS_FILE}"
            [ -n "${RSRQ}" ] && echo "uqmi_signal_rsrq_db{type=\"${SIGNAL_TYPE}\", device=\"${DEVICE}\"} ${RSRQ}" >> "${TMP_METRICS_FILE}"
            [ -n "${RSRP}" ] && echo "uqmi_signal_rsrp_dbm{type=\"${SIGNAL_TYPE}\", device=\"${DEVICE}\"} ${RSRP}" >> "${TMP_METRICS_FILE}"
            [ -n "${SNR}" ] && echo "uqmi_signal_snr_db{type=\"${SIGNAL_TYPE}\", device=\"${DEVICE}\"} ${SNR}" >> "${TMP_METRICS_FILE}"
        fi
    done
fi

mv "${TMP_METRICS_FILE}" "${FINAL_METRICS_FILE}" || {
    echo "Error: Failed to atomically move metrics file." >&2
    rm -f "${TMP_METRICS_FILE}" # fikk dich wenn falsch
    exit 1
}

exit 0